<?php
/* --------------------------------------------------------------
   configuration.lang.inc.php 2023-02-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

$t_language_text_section_content_array = [
    'ACCOUNT_ADDITIONAL_INFO_DESC'                    => 'Anzeige eines Adresszusatzfeldes (für Etagenangaben, etc.)',
    'ACCOUNT_ADDITIONAL_INFO_TITLE'                   => 'Adresszusatzfeld anzeigen',
    'ACCOUNT_B2B_STATUS_DESC'                         => 'Die Abfrage für den Gewerbetreibender-Status im Account benutzen',
    'ACCOUNT_B2B_STATUS_TITLE'                        => 'Gewerbetreibender-Status',
    'ACCOUNT_COMPANY_DESC'                            => 'Die Abfrage für die Firma im Account benutzen',
    'ACCOUNT_COMPANY_TITLE'                           => 'Firma',
    'ACCOUNT_COMPANY_REQUIRED_TITLE'                  => 'Firma pflicht',
    'ACCOUNT_COMPANY_REQUIRED_DESC'                   => 'Wenn diese Option deaktiviert ist, muss dass Feld Firma leer sein oder die Mindestanzahl an Zeichen enthalten. Darf nicht mit Vor- & Nachname optional kombiniert werden.',
    'ACCOUNT_COMPANY_VAT_CHECK_DESC'                  => 'Die USt-IdNr. auf Plausibilität überprüfen?<br /><strong>Hinweis: Die USt-IdNr. wird lediglich auf Plausibilität geprüft. Eine genauere Live-Überprüfung ist über das untenstehende Modul möglich.</strong>',
    'ACCOUNT_COMPANY_VAT_CHECK_TITLE'                 => 'USt-IdNr. überprüfen',
    'ACCOUNT_COMPANY_VAT_GROUP_DESC'                  => 'Durch Einschalten dieser Option wird die Kundengruppe nach einer postiven USt-IdNr.-Überprüfung geändert.',
    'ACCOUNT_COMPANY_VAT_GROUP_TITLE'                 => 'Kundengruppe nach USt-IdNr. Überprüfung anpassen?',
    'ACCOUNT_COMPANY_VAT_LIVE_CHECK_DESC'             => 'Die USt-IdNr. live auf Plausibilität überprüfen, falls keine Berechnungsgrundlage vorhanden?<br /><strong>Hinweis: Bitte beachten, dass auf dem Server die Funktion "fsockopen" oder "curl" zur Verfügung stehen muss, um die Live-Überprüfung auf Plausibilität durchzuführen.</strong>',
    'ACCOUNT_COMPANY_VAT_LIVE_CHECK_TITLE'            => 'USt-IdNr. live überprüfen',
    'ACCOUNT_DEFAULT_B2B_STATUS_DESC'                 => 'Standardwert für Gewerbetreibender-Status bei der Kundenregistrierung (Dieser Wert greift auch, wenn der Gewerbetreibender-Status nicht angezeigt wird)',
    'ACCOUNT_DEFAULT_B2B_STATUS_TITLE'                => 'Standardwert für Gewerbetreibender-Status',
    'ACCOUNT_DOB_DESC'                                => 'Die Abfrage für das Geburtsdatum im Account benutzen',
    'ACCOUNT_DOB_TITLE'                               => 'Geburtsdatum',
    'ACCOUNT_FAX_DESC'                                => 'Die Abfrage der Faxnummer in der Kontoerstellung aktivieren',
    'ACCOUNT_FAX_TITLE'                               => 'Faxnummer',
    'ACCOUNT_GENDER_DESC'                             => 'Die Abfrage für die Anrede im Account benutzen',
    'ACCOUNT_GENDER_TITLE'                            => 'Anrede',
    'ACCOUNT_NAMES_OPTIONAL_DESC'                     => 'Vor- & Nachname optional. Kann nicht mit deaktiviertem "Firma pflicht" kombiniert werden.',
    'ACCOUNT_NAMES_OPTIONAL_TITLE'                    => 'Vor- & Nachname optional',
    'ACCOUNT_OPTIONS_DESC'                            => 'Wie möchtest du die Anmeldeprozedur in deinem Shop gestalten?<br />Du hast die Wahl zwischen Kundenkonten und Gastkonten (Einmal-Bestellungen) ohne Erstellung eines Kundenkontos (es wird ein Konto erstellt, aber dies ist für den Kunden nicht ersichtlich).',
    'ACCOUNT_OPTIONS_TITLE'                           => 'Art der Kontoerstellung',
    'ACCOUNT_SPLIT_STREET_INFORMATION_DESC'           => 'Straße und Hausnummer getrennt voneinander abspeichern?',
    'ACCOUNT_SPLIT_STREET_INFORMATION_TITLE'          => 'Straße und Hausnummer trennen',
    'ACCOUNT_SPLIT_STREET_INFORMATION_WARNING'        => 'Externe Module (Zahlungsmodule, ERP, Warenwirtschaften etc.) müssen Straße und Hausnummer getrennt verarbeiten können. Wenn du dir nicht sicher bist, lasse diese Option deaktiviert.',
    'ACCOUNT_STATE_DESC'                              => 'Die Abfrage für das Bundesland im Account benutzen',
    'ACCOUNT_STATE_TITLE'                             => 'Bundesland',
    'ACCOUNT_SUBURB_DESC'                             => 'Die Abfrage für den Stadtteil im Account benutzen',
    'ACCOUNT_SUBURB_TITLE'                            => 'Stadtteil',
    'ACCOUNT_TELEPHONE_DESC'                          => 'Die Abfrage der Telefonnummer in der Kontoerstellung aktivieren',
    'ACCOUNT_TELEPHONE_TITLE'                         => 'Telefonnummer',
    'ACCOUNT_TYPE_DEFAULT_TITLE'                      => 'Vorgabe für Kontoart',
    'ACCOUNT_TYPE_DEFAULT_DESC'                       => 'Welche Kontoart soll bei der Anmeldung vorausgewählt sein?',
    'ACCOUNT_VAT_BLOCK_ERROR_DESC'                    => 'Durch Einschalten dieser Option werden nur geprüfte und richtige Ust-Id Nummern eingetragen.',
    'ACCOUNT_VAT_BLOCK_ERROR_TITLE'                   => 'Eintragung falscher oder ungeprüfter Ust-Id Nummern sperren?',
    'ACCOUNT_CONFIRMATION_EMAIL_TITLE'                => 'E-Mail bestätigen',
    'ACCOUNT_CONFIRMATION_EMAIL_DESC'                 => 'Das Feld "E-Mail bestätigen" beim Erstellen eines Kundenkontos anzeigen',
    'ACTIVATE_GIFT_SYSTEM_DESC'                       => 'Gutscheinsystem aktivieren?',
    'ACTIVATE_GIFT_SYSTEM_TITLE'                      => 'Gutscheinsystem aktivieren?',
    'ACTIVATE_NAVIGATOR_DESC'                         => 'Artikelnavigator in der Artikeldetailansicht aktivieren/deaktivieren (aus Performancegründen bei hoher Artikelanzahl sinnvoll)',
    'ACTIVATE_NAVIGATOR_TITLE'                        => 'Artikelnavigator aktivieren?',
    'ACTIVATE_PAGE_TOKEN_DESC'                        => 'Page-Token System aktivieren?',
    'ACTIVATE_PAGE_TOKEN_TITLE'                       => 'Page-Token System',
    'ACTIVATE_REVERSE_CROSS_SELLING_DESC'             => 'Reverse Cross-Marketing Funktion aktivieren?',
    'ACTIVATE_REVERSE_CROSS_SELLING_TITLE'            => 'Reverse Cross-Marketing',
    'ADVANCED_SEARCH_DEFAULT_OPERATOR_DESC'           => 'Sollen alle Suchbegriffe im Suchergebnis vorkommen ("und") oder muss nur mindestens ein Suchbegriff vorkommen ("oder")?',
    'ADVANCED_SEARCH_DEFAULT_OPERATOR_TITLE'          => 'Suchverknüpfung',
    'AFTERBUY_ACTIVATED_DESC'                         => 'Afterbuyschnittstelle aktivieren',
    'AFTERBUY_ACTIVATED_TITLE'                        => 'Aktiv',
    'AFTERBUY_ORDERSTATUS_DESC'                       => 'Bestellstatus nach erfolgreicher Übetragung der Bestelldaten',
    'AFTERBUY_ORDERSTATUS_TITLE'                      => 'Bestellstatus',
    'AFTERBUY_PARTNERID_DESC'                         => 'Deine Afterbuy Partner ID',
    'AFTERBUY_PARTNERID_TITLE'                        => 'Partner ID',
    'AFTERBUY_PARTNERPASS_DESC'                       => 'Dein Partner Passwort für die Afterbuy XML Schnittstelle',
    'AFTERBUY_PARTNERPASS_TITLE'                      => 'Partner Passwort',
    'AFTERBUY_URL'                                    => 'Eine Beschreibung von Afterbuy findest du hier: <a href="http://www.xt-commerce.com/modules/wfsection/dossier-65.html" target="new">http://www.xt-commerce.com/modules/wfsection/dossier-65.html</a>',
    'AFTERBUY_USERID_DESC'                            => 'Deine Afterbuy User ID',
    'AFTERBUY_USERID_TITLE'                           => 'User ID',
    'ALLOW_DISCOUNT_ON_PRODUCTS_ATTRIBUTES_DESC'      => 'Erlaubt, den eingestellten Rabatt der Kundengruppe auch auf die Artikeloptionen anzuwenden (Nur wenn der Artikel nicht als "Sonderangebot" ausgewiesen ist)',
    'ALLOW_DISCOUNT_ON_PRODUCTS_ATTRIBUTES_TITLE'     => 'Rabatte auch auf die Artikeloptionen verwenden?',
    'ALLOW_GUEST_TO_TELL_A_FRIEND_DESC'               => 'Gästen die Nutzung des "Frage zum Artikel"-Modul erlauben?',
    'ALLOW_GUEST_TO_TELL_A_FRIEND_TITLE'              => 'Gästen die Nutzung des "Frage zum Artikel"-Modul erlauben?',
    'APPEND_PROPERTIES_MODEL_DESC'                    => 'Soll die Artikelvarianten-Artikelnummer an die Haupt-Artikelnummer angehängt werden statt sie zu ersetzen?',
    'APPEND_PROPERTIES_MODEL_TITLE'                   => 'Artikelvarianten-Artikelnummer anhängen',
    'ATTRIBUTE_STOCK_CHECK_DESC'                      => 'Überprüfen, ob Bestand von Artikeloptionen in ausreichender Menge auf Lager ist, um Bestellung ausführen zu können?<br />Funktioniert nur, wenn "Überprüfen des Artikelbestandes" auf "Ja" steht.',
    'ATTRIBUTE_STOCK_CHECK_TITLE'                     => 'Überprüfen des Artikeloptionen-Bestandes',
    'CACHE_CHECK_DESC'                                => 'Wenn "ja", dann werden "If-Modified-Since headers" bei gecachetem Inhalt berücksichtigt und passende HTTP headers ausgegeben. Somit werden regelmäßig aufgerufene Seiten nicht jedes Mal neu an den Client versandt.',
    'CACHE_CHECK_TITLE'                               => 'Prüfe ob Cache modifiziert',
    'CACHE_LIFETIME_DESC'                             => 'Zeit in Sekunden, bevor Cache Datein automatisch überschrieben werden.',
    'CACHE_LIFETIME_TITLE'                            => 'Cache Lebenszeit',
    'CALCULATE_TAX_BASED_ON_VAT_ID_DESC'              => 'Für internationale EU-Kunden mit gültiger USt-IdNr. keine Steuer ausweisen? Die Kundengruppenkonfiguration wird übergangen.',
    'CALCULATE_TAX_BASED_ON_VAT_ID_TITLE'             => 'Netto-Preisanzeige anhand USt-IdNr. bestimmen',
    'CC_KEYCHAIN_DESC'                                => 'Beliebige Zeichenfolge (wie ein Passwort) zur verschlüsselten Speicherung der Kreditkarten-Informationen in der Datenbank. (Bitte unbedingt ändern!)',
    'CC_KEYCHAIN_TITLE'                               => 'CC String',
    'CC_NUMBER_MIN_LENGTH_DESC'                       => 'Minimum Länge von Kreditkartennummern',
    'CC_NUMBER_MIN_LENGTH_TITLE'                      => 'Kreditkartennummer',
    'CC_OWNER_MIN_LENGTH_DESC'                        => 'Minimum Länge des Namens des Kreditkarteninhabers',
    'CC_OWNER_MIN_LENGTH_TITLE'                       => 'Kreditkarteninhaber',
    'CHECK_CLIENT_AGENT_DESC'                         => 'Bekannte Suchmaschinen Spider ohne Session auf die Seite lassen.',
    'CHECK_CLIENT_AGENT_TITLE'                        => 'Spider Sessions vermeiden?',
    'COMPANY_NAME_TITLE'                              => 'Firmenname',
    'CONFIG_CALCULATE_IMAGE_SIZE_DESC'                => 'Sollte es keine Vorgabe für eine der Bilddimensionen (Breite oder Höhe) geben, wird diese anhand der anderen Dimension und des Seitenverhältnisses errechnet.',
    'CONFIG_CALCULATE_IMAGE_SIZE_TITLE'               => 'Bildgröße berechnen',
    'CONTACT_US_EMAIL_ADDRESS_DESC'                   => 'Bitte gib eine korrekte Absender-Adresse für das Versenden der E-Mails über das Kontakt-Formular ein.',
    'CONTACT_US_EMAIL_ADDRESS_TITLE'                  => 'Kontakt - E-Mail-Adresse',
    'CONTACT_US_FORWARDING_STRING_DESC'               => 'Gib weitere E-Mail-Adressen ein, an die die E-Mails des Kontakt-Formulars noch versendet werden sollen (kommagetrennt).',
    'CONTACT_US_FORWARDING_STRING_TITLE'              => 'Kontakt - Weiterleitungsadressen',
    'CONTACT_US_NAME_DESC'                            => 'Bitte gib einen Absender-Namen für das Versenden der E-Mails über das Kontakt-Formular ein.',
    'CONTACT_US_NAME_TITLE'                           => 'Kontakt - E-Mail-Adresse, Name',
    'CONTACT_US_REPLY_ADDRESS_DESC'                   => 'Bitte gib eine E-Mailadresse ein, an die deine Kunden Antworten können.',
    'CONTACT_US_REPLY_ADDRESS_NAME_DESC'              => 'Absendername für Antwortmails',
    'CONTACT_US_REPLY_ADDRESS_NAME_TITLE'             => 'Kontakt - Antwortadresse, Name',
    'CONTACT_US_REPLY_ADDRESS_TITLE'                  => 'Kontakt - Antwortadresse',
    'CURRENT_TEMPLATE_DESC'                           => 'Wählen hier dein gewünschtes Theme für deinen Shop aus.',
    'CURRENT_THEME_UPDATE_REQUIRED'                   => 'Ben&ouml;tigt Update',
    'CURRENT_TEMPLATE_TITLE'                          => 'Templateset (Theme)',
    'DATE_TIMEZONE_DESC'                              => 'Zeitzone',
    'DATE_TIMEZONE_TITLE'                             => 'Deine Zeitzone',
    'DB_CACHE_DESC'                                   => 'SELECT Abfragen können gecached werden, um die Datenbankabfragen und somit die Ladezeiten zu verringern.<br /><br /><font color="#FF0000"><strong>ACHTUNG:</strong> </font>Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren und dir sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'DB_CACHE_EXPIRE_DESC'                            => 'Zeit in Sekunden, bevor Cache Dateien mit Daten aus der Datenbank automatisch überschrieben werden.',
    'DB_CACHE_EXPIRE_TITLE'                           => 'Datenbank-Cache Lebenszeit',
    'DB_CACHE_TITLE'                                  => 'Datenbank-Cache',
    'DEFAULT_CURRENCY_DESC'                           => 'Währung die standardmäßig benutzt wird',
    'DEFAULT_CURRENCY_TITLE'                          => 'Standard Währung',
    'DEFAULT_CUSTOMERS_STATUS_ID_ADMIN_DESC'          => 'Wähle die Kundengruppe für Administratoren aus (Standard "Admin").',
    'DEFAULT_CUSTOMERS_STATUS_ID_ADMIN_TITLE'         => 'Kundengruppe für Administratoren',
    'DEFAULT_CUSTOMERS_STATUS_ID_DESC'                => 'Wähle die Kundengruppe für Neukunden aus (Standard "Neuer Kunde").<br />TIPP: Du kannst im Menü unter "Kundengruppen" weitere Gruppen einrichten und z. B. Aktionswochen machen: Diese Woche 10% Rabatt für alle Neukunden!',
    'DEFAULT_CUSTOMERS_STATUS_ID_GUEST_DESC'          => 'Wähledie Kundengruppe für Gäste aus (Standard "Gast").',
    'DEFAULT_CUSTOMERS_STATUS_ID_GUEST_TITLE'         => 'Kundengruppe für Gäste',
    'DEFAULT_CUSTOMERS_STATUS_ID_TITLE'               => 'Kundengruppe für Neukunden',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_DESC'            => 'Wähle die Kundengruppe für USt-IdNr.-geprüfte Kunden aus!',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL_DESC'      => 'Wähle die Kundengruppe für USt-IdNr.-geprüfte Kunden aus!',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL_TITLE'     => 'Kundengruppe für USt-IdNr.-geprüfte Kunden (Inland)',
    'DEFAULT_CUSTOMERS_VAT_STATUS_ID_TITLE'           => 'Kundengruppe für USt-IdNr.-geprüfte Kunden (Ausland)',
    'DEFAULT_LANGUAGE_DESC'                           => 'Sprache die standardmäßig benutzt wird',
    'DEFAULT_LANGUAGE_TITLE'                          => 'Standard Sprache',
    'DEFAULT_ORDERS_STATUS_ID_DESC'                   => 'Wenn eine neue Bestellung eingeht, wird dieser Status als Bestellstatus gesetzt.',
    'DEFAULT_ORDERS_STATUS_ID_TITLE'                  => 'Standard Bestellstatus bei neuen Bestellungen',
    'DELETE_GUEST_ACCOUNT_DESC'                       => 'Sollen Gastkonten nach erfolgter Bestellung gelöscht werden? (Bestelldaten bleiben erhalten)',
    'DELETE_GUEST_ACCOUNT_TITLE'                      => 'Löschen von Gastkonten',
    'DIR_FS_CACHE_DESC'                               => 'Der Ordner, in dem die gecachten Dateien gespeichert werden sollen',
    'DIR_FS_CACHE_TITLE'                              => 'Cache Ordner',
    'DISPLAY_CART_DESC'                               => 'Nach dem Hinzufügen eines Artikels in den Warenkorb zum Warenkorb wechseln oder auf aktueller Seite bleiben?',
    'DISPLAY_CART_TITLE'                              => 'Soll nach Ablegen eines Artikels in den Warenkorb der Warenkorb angezeigt werden?',
    'DISPLAY_CONDITIONS_ON_CHECKOUT_DESC'             => 'Anzeigen und Akzeptieren der AGB beim Bestellvorgang',
    'DISPLAY_CONDITIONS_ON_CHECKOUT_TITLE'            => 'Akzeptieren der AGB erforderlich',
    'DISPLAY_PAGE_PARSE_TIME_DESC'                    => 'Wenn das Speichern der Berechnungszeit für Seiten eingeschaltet ist, können diese im Footer (Seitenende) angezeigt werden.',
    'DISPLAY_PAGE_PARSE_TIME_TITLE'                   => 'Berechnungszeit der Seiten anzeigen',
    'DISPLAY_PRICE_WITH_TAX_DESC'                     => 'Preise inklusive Steuer anzeigen (true) oder am Ende aufrechnen (false)',
    'DISPLAY_PRICE_WITH_TAX_TITLE'                    => 'Preis inkl. MwSt. anzeigen',
    'DISPLAY_REVOCATION_ON_CHECKOUT_DESC'             => 'Widerrufsrecht im Bestellvorgang anzeigen?',
    'DISPLAY_REVOCATION_ON_CHECKOUT_TITLE'            => 'Anzeige Widerrufsrecht?',
    'DOWNLOAD_BY_REDIRECT_DESC'                       => 'Browser-Umleitung für Artikeldownloads benutzen. Auf Nicht-Linux/Unix Systemen ausschalten.',
    'DOWNLOAD_BY_REDIRECT_TITLE'                      => 'Download durch Weiterleitung',
    'DOWNLOAD_ENABLED_DESC'                           => 'Artikel-Download Funktionen einschalten (Software etc.)',
    'DOWNLOAD_ENABLED_TITLE'                          => 'Download von Artikeln erlauben',
    'DOWNLOAD_MAX_COUNT_DESC'                         => 'Stelle die maximale Anzahl an Downloads ein, die du dem Kunden erlaubst, der einen Artikel dieser Art erworben hat. 0 bedeutet kein Download.',
    'DOWNLOAD_MAX_COUNT_TITLE'                        => 'Maximale Anzahl der Downloads eines gekauften Medienproduktes',
    'DOWNLOAD_MAX_DAYS_DESC'                          => 'Anzahl an Tagen, die ein Download Link für den Kunden aktiv bleibt. 0 bedeutet ohne Limit.',
    'DOWNLOAD_MAX_DAYS_TITLE'                         => 'Verfallsdatum der Download Links(Tage)',
    'DOWNLOAD_MIN_ORDERS_STATUS_DESC'                 => 'Download-Bestellstatus, für die Downloads freigegeben sind.',
    'DOWNLOAD_MIN_ORDERS_STATUS_TITLE'                => 'Download-Bestellstatus',
    'DOWNLOAD_STOCK_CHECK_DESC'                       => 'Prüfen, ob die Download-Artikel in angeforderter Menge auf Lager sind, um Bestellung ausführen zu können?',
    'DOWNLOAD_STOCK_CHECK_TITLE'                      => 'Überprüfen des Downloadartikel-Bestandes',
    'DOWNLOAD_UNALLOWED_PAYMENT_DESC'                 => 'Nicht erlaubte Zahlungsweisen für Downloadartikel durch Komma getrennt. Z. B.: banktransfer,cod,invoice,moneyorder',
    'DOWNLOAD_UNALLOWED_PAYMENT_TITLE'                => 'Ausgeschlossene Zahlungsmodule',
    'EMAIL_BILLING_ADDRESS_DESC'                      => 'Bitte gib eine korrekte Absenderadresse für das Versenden der E-Mails über das <strong>Verrechnungssystem</strong> ein (Bestellbestätigung, Statusänderungen etc.).',
    'EMAIL_BILLING_ADDRESS_TITLE'                     => 'Verrechnung - E-Mail-Adresse',
    'EMAIL_BILLING_FORWARDING_STRING_DESC'            => 'Gib weitere E-Mail-Adressen ein, an die die E-Mails des <strong>Verrechnungssystems</strong> noch versendet werden sollen (kommagetrennt).',
    'EMAIL_BILLING_FORWARDING_STRING_TITLE'           => 'Verrechnung - Weiterleitungsadressen',
    'EMAIL_BILLING_NAME_DESC'                         => 'Bitte gib einen Absendernamen für das Versenden der E-Mails über das <strong>Verrechnungssystem</strong> ein (Bestellbestätigung,Statusänderungen etc.).',
    'EMAIL_BILLING_NAME_TITLE'                        => 'Verrechnung - E-Mail-Adresse, Name',
    'EMAIL_BILLING_REPLY_ADDRESS_DESC'                => 'Bitte gib eine E-Mail-Adresse ein, an die deine Kunden antworten können.',
    'EMAIL_BILLING_REPLY_ADDRESS_NAME_DESC'           => 'Absendername für Antwort E-Mails.',
    'EMAIL_BILLING_REPLY_ADDRESS_NAME_TITLE'          => 'Verrechnung - Antwortadresse, Name',
    'EMAIL_BILLING_REPLY_ADDRESS_TITLE'               => 'Verrechnung - Antwortadresse',
    'EMAIL_BILLING_SUBJECT_DESC'                      => 'Gib bitte einen E-Mail-Betreff für E-Mails des <strong>Verrechnungssystem</strong> deines Shops ein.',
    'EMAIL_BILLING_SUBJECT_ORDER_DESC'                => 'Gib bitte einen E-Mail-Betreff für deine Bestellmails an (z. B.: Ihre Bestellung {$nr}, am {$date}). Es stehen folgende Variablen zur Verfügung: {$nr}, {$date}, {$firstname}, {$lastname}. <br/> Diese Eingabe ist erforderlich.',
    'EMAIL_BILLING_SUBJECT_ORDER_TITLE'               => 'Verrechnung - Betreff Bestellbestätigung',
    'EMAIL_BILLING_SUBJECT_TITLE'                     => 'Verrechnung - E-Mail Betreff',
    'EMAIL_FROM_DESC'                                 => 'Die E-Mail-Adresse, die beim Versenden (sendmail) benutzt werden soll.',
    'EMAIL_FROM_TITLE'                                => 'E-Mail von',
    'EMAIL_LINEFEED_DESC'                             => 'Definiert die Zeichen, die benutzt werden sollen, um die Mail Header zu trennen.',
    'EMAIL_LINEFEED_TITLE'                            => 'E-Mail Linefeeds',
    'EMAIL_MAX_LIMIT_TITLE'                           => 'Maximale Anzahl E-Mails pro Versand',
    'EMAIL_SIGNATURE_DESC'                            => 'Diese Signatur wird in deinen E-Mail-Vorlagen anstelle der Variable {$EMAIL_SIGNATURE_TEXT} eingesetzt.',
    'EMAIL_SIGNATURE_TITLE'                           => 'E-Mail-Signatur (nur Text)',
    'EMAIL_HTML_SIGNATURE_TITLE'                      => 'E-Mail-Signatur (HTML)',
    'EMAIL_HTML_SIGNATURE_DESC'                       => 'Diese Signatur wird in deinen E-Mail-Vorlagen anstelle der Variable {$EMAIL_SIGNATURE_HTML} eingesetzt.',
    'EMAIL_SUPPORT_ADDRESS_DESC'                      => 'Bitte gib eine korrekte Absender-Adresse für das Versenden der E-Mails über das <strong>Support System</strong> ein (Kontoerstellung, Passwortänderung).',
    'EMAIL_SUPPORT_ADDRESS_TITLE'                     => 'Technischer Support - E-Mail-Adresse',
    'EMAIL_SUPPORT_FORWARDING_STRING_DESC'            => 'Gib weitere E-Mail-Adressen ein, an die die E-Mails des <strong>Support Systems</strong> noch versendet werden sollen (kommagetrennt).',
    'EMAIL_SUPPORT_FORWARDING_STRING_TITLE'           => 'Technischer Support - Weiterleitungsadressen',
    'EMAIL_SUPPORT_NAME_DESC'                         => 'Bitte gib einen Absender-Namen für das Versenden der E-Mails über das <strong>Support System</strong> ein (Kontoerstellung, Passwortänderung).',
    'EMAIL_SUPPORT_NAME_TITLE'                        => 'Technischer Support - E-Mail-Adresse, Name',
    'EMAIL_SUPPORT_REPLY_ADDRESS_DESC'                => 'Bitte gib eine E-Mailadresse ein, an die deine Kunden antworten können.',
    'EMAIL_SUPPORT_REPLY_ADDRESS_NAME_DESC'           => 'Absendername für Antwortmails',
    'EMAIL_SUPPORT_REPLY_ADDRESS_NAME_TITLE'          => 'Technischer Support - Antwortadresse, Name',
    'EMAIL_SUPPORT_REPLY_ADDRESS_TITLE'               => 'Technischer Support - Antwortadresse',
    'EMAIL_SUPPORT_SUBJECT_DESC'                      => 'Betreff für E-Mails des <strong>Support Systems</strong>',
    'EMAIL_SUPPORT_SUBJECT_TITLE'                     => 'Technischer Support - E-Mail Betreff',
    'EMAIL_TRANSPORT_DESC'                            => 'Definiert, ob der Server die PHP mail-Funktion, eine lokale Verbindung zum "Sendmail-Programm" benutzt oder ob er eine SMTP Verbindung über TCP/IP benötigt. Server die auf Windows oder MacOS laufen, sollten SMTP verwenden. "mail" ist Standard und sollte aktiviert sein, wenn E-Mails erfolgreich versendet werden.',
    'EMAIL_TRANSPORT_TITLE'                           => 'E-Mail Transport-Methode',
    'EMAIL_USE_HTML_DESC'                             => 'E-Mails im HTML Format versenden',
    'EMAIL_USE_HTML_TITLE'                            => 'HTML E-Mails senden',
    'ENTRY_CITY_MIN_LENGTH_DESC'                      => 'Mindestlänge des Städtenamens',
    'ENTRY_CITY_MIN_LENGTH_TITLE'                     => 'Stadt',
    'ENTRY_COMPANY_MIN_LENGTH_DESC'                   => 'Mindestlänge des Firmennamens',
    'ENTRY_COMPANY_MIN_LENGTH_TITLE'                  => 'Firma',
    'ENTRY_DOB_MIN_LENGTH_DESC'                       => 'Mindestlänge des Geburtsdatums',
    'ENTRY_DOB_MIN_LENGTH_TITLE'                      => 'Geburtsdatum',
    'ENTRY_EMAIL_ADDRESS_CHECK_DESC'                  => 'Die E-Mail-Adressen können über einen DNS Server auf Gültigkeit geprüft werden.',
    'ENTRY_EMAIL_ADDRESS_CHECK_TITLE'                 => 'Überprüfen der E-Mail-Adressen über DNS',
    'ENTRY_EMAIL_ADDRESS_MIN_LENGTH_DESC'             => 'Mindestlänge der E-Mail-Adresse',
    'ENTRY_EMAIL_ADDRESS_MIN_LENGTH_TITLE'            => 'E-Mail-Adresse',
    'ENTRY_FIRST_NAME_MIN_LENGTH_DESC'                => 'Mindestlänge des Vornamens',
    'ENTRY_FIRST_NAME_MIN_LENGTH_TITLE'               => 'Vorname',
    'ENTRY_HOUSENUMBER_MIN_LENGTH_DESC'               => 'Mindestlänge der Hausnummer (nur aktiv, wenn Hausnummer und Straßenname getrennt dargestellt werden.',
    'ENTRY_HOUSENUMBER_MIN_LENGTH_TITLE'              => 'Hausnummer',
    'ENTRY_LAST_NAME_MIN_LENGTH_DESC'                 => 'Mindestlänge des Nachnamens',
    'ENTRY_LAST_NAME_MIN_LENGTH_TITLE'                => 'Nachname',
    'ENTRY_PASSWORD_MIN_LENGTH_DESC'                  => 'Mindestlänge des Passworts',
    'ENTRY_PASSWORD_MIN_LENGTH_TITLE'                 => 'Passwort',
    'ENTRY_POSTCODE_MIN_LENGTH_DESC'                  => 'Mindestlänge der Postleitzahl',
    'ENTRY_POSTCODE_MIN_LENGTH_TITLE'                 => 'Postleitzahl',
    'ENTRY_STATE_MIN_LENGTH_DESC'                     => 'Mindestlänge des Bundeslandes',
    'ENTRY_STATE_MIN_LENGTH_TITLE'                    => 'Bundesland',
    'ENTRY_STREET_ADDRESS_MIN_LENGTH_DESC'            => 'Mindestlänge der Straßenanschrift',
    'ENTRY_STREET_ADDRESS_MIN_LENGTH_TITLE'           => 'Straße',
    'ENTRY_TELEPHONE_MIN_LENGTH_DESC'                 => 'Mindestlänge der Telefonnummer',
    'ENTRY_TELEPHONE_MIN_LENGTH_TITLE'                => 'Telefonnummer',
    'ERROR_IMAGE_QUALITY'                             => 'Gib einen numerischen Wert zwischen 0 und 100 ein.',
    'ERROR_MO_PICS'                                   => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_INFO_HEIGHT'                 => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_INFO_WIDTH'                  => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_POPUP_HEIGHT'                => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_POPUP_WIDTH'                 => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_HEIGHT'            => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_PRODUCT_IMAGE_THUMBNAIL_WIDTH'             => 'Gib einen positiven numerischen Wert ein.',
    'ERROR_REPORT_EMAIL_DESC'                         => 'Keine Berichte senden: Feld leer lassen.<br/>Gambio Support: debug@gambio-support.de',
    'ERROR_REPORT_EMAIL_TITLE'                        => 'E-Mail-Fehlerberichte an',
    'EXPECTED_PRODUCTS_FIELD_DESC'                    => 'Hier wird angegeben, wonach die Artikelankündigungen sortiert werden sollen.',
    'EXPECTED_PRODUCTS_FIELD_TITLE'                   => 'Artikelankündigungen sortieren nach',
    'EXPECTED_PRODUCTS_SORT_DESC'                     => 'Das ist die Reihenfolge, wie angekündigte Artikel angezeigt werden.',
    'EXPECTED_PRODUCTS_SORT_TITLE'                    => 'Reihenfolge für Artikelankündigungen',
    'GAMBIO_SHOP_KEY_DESC'                            => 'Bitte hinterlege hier deinen Gambio Shop-Key, den du im Gambio Kundenportal unter (<a href="http://www.gambio-support.de/" target="_blank">www.gambio-support.de</a>) erhalten hast. Durch das Hinterlegen deines Gambio Shop-Keys im Gambio Admin deines Shops genießt du viele Vorteile: Du wirst beispielsweise zukünftig über die Admin-Infobox automatisch über Updates für deinen Shop informiert. Um Support-Anfragen schneller und effizienter beantworten zu können, benötigen wir die nachfolgenden Informationen zu deinem Shop, die durch das Hinterlegen des Shop-Keys automatisch an das Kundenportal weitergeleitet werden. <br /> <br /> Wenn du hier deinen Shop-Key hinterlegst, werden der Shop-Key, deine Shop-URL, die zum Zeitpunkt der Datenübertragung ans Gambio-Kundenportal im Gambio Admin aktive Sprache sowie relevante Versionsinformationen zu deinem Shop und den installierten Modulen (nachfolgend "Shopdaten" genannt) an das Gambio-Kundenportal übermittelt und gespeichert. Deine Shopdaten werden automatisch in deinem Kundenkonto im Gambio Kundenportal hinterlegt und regelmäßig durch deinen Shop aktualisiert, wodurch die dort hinterlegten Daten stets aktuell sind. <br /> <br /> Wenn du nicht mehr möchtest, dass deine Shopdaten an das Kundenportal übertragen werden, klicke auf "Shop-Key löschen". Außer den oben genannten Shopdaten werden keine weiteren Daten übertragen. Selbstverständlich werden wir die Shopdaten zu deinem Shop nicht an Dritte weitergeben und nur in dem Rahmen nutzen, der für die Erbringung der Dienstleistung oder die Durchführung des Vertrages notwendig ist. Im Gambio-Kundenportal kannst du die übermittelten Shopdaten jederzeit einsehen und bei Bedarf löschen.<br /> <br /> Näheres erfährst du in unserer <a href="https://www.gambio.de/rechtliches/datenschutz" target="_blank"><u>Datenschutzerklärung</u></a>.<br /> <br /> <a href="#" class="button" onclick="$(\'input[name=GAMBIO_SHOP_KEY]\').val(\'\'); $(\'form[name=configuration]\').submit(); return false;">Shop-Key löschen</a><br /> <br /> <br /> Folgende Shopdaten werden an das Gambio-Kundenportal übermittelt:',
    'GAMBIO_SHOP_KEY_TITLE'                           => 'Gambio Shop-Key',
    'GM_LIVE_CHECK_NOT_READY'                         => '<br /><br /><font color="#ff0000"><strong>ACHTUNG:</strong></font> Weder die php-Funktion fsockopen noch curl sind auf diesem Server verfügbar. Wir empfehlen, diese Option <strong>nicht</strong> zu aktivieren. Sollten nun generell Ust-Id-Nummern nicht mehr validiert werden können, deaktiviere die USt-IdNr.-Prüfung generell.',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_DESC'             => 'Attributwerte/Attribut-Optionswerte ausblenden, wenn diese nicht mehr auf Lager sind?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Falls alle Attribute eines Artikels nicht mehr auf Lager sind, so wird der Artikel OHNE Attribute in den Warenkorb gelegt! Daher solltest du diese Option nur in Verbindung mit der aktivierten Option "Artikel inaktiv setzen" nutzen, damit Artikel, die nicht mehr auf Lager sind, nicht mehr angezeigt werden.',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW_DESC'        => 'Artikeloptionen-Lagerbestand hinter jedem Artikeloptionen-Optionswert anzeigen?',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_SHOW_TITLE'       => 'Artikeloptionenlagerbestand anzeigen',
    'GM_SET_OUT_OF_STOCK_ATTRIBUTES_TITLE'            => 'Artikeloptionen inaktiv setzen',
    'GM_SET_OUT_OF_STOCK_PRODUCTS_DESC'               => 'Artikel auf inaktiv setzen, wenn diese nach einer Bestellung nicht mehr auf Lager sind?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">"Überprüfen des Artikelbestandes" und "Artikelmenge abziehen" muss auf "Ja" und "Einkaufen nicht vorrätiger Artikel erlauben" auf "Nein" eingestellt sein.',
    'GM_SET_OUT_OF_STOCK_PRODUCTS_TITLE'              => 'Artikel inaktiv setzen',
    'GROUP_CHECK_DESC'                                => 'Nur bestimmten Kundengruppen Zugang zu einzelnen Kategorien, Artikeln, Content-Elementen erlauben? Nach Aktivierung erscheinen Eingabemöglichkeiten bei Artikeln, Kategorien und im Content-Manager.',
    'GROUP_CHECK_TITLE'                               => 'Kundengruppencheck',
    'GZIP_COMPRESSION_DESC'                           => 'Schalte die HTTP GZip Kompression ein, um die Seitenaufbaugeschwindigkeit zu optimieren.',
    'GZIP_COMPRESSION_TITLE'                          => 'GZip Kompression einschalten',
    'GZIP_LEVEL_DESC'                                 => 'Wähle ein Kompressionslevel zwischen 1 und 9 (1 = Minimum, 9 = Maximum).',
    'GZIP_LEVEL_TITLE'                                => 'Kompressionslevel',
    'HEADING_IMAGE_HEIGHT_DESC'                       => 'Maximale Höhe der Überschriftbilder in Pixeln',
    'HEADING_IMAGE_HEIGHT_TITLE'                      => 'Höhe der Überschrift Bilder',
    'HEADING_IMAGE_WIDTH_DESC'                        => 'Maximale Breite der Überschrift Bilder in Pixeln',
    'HEADING_IMAGE_WIDTH_TITLE'                       => 'Breite der Überschrift Bilder',
    'HEADING_SUB_TITLE'                               => 'Konfiguration',
    'HTML_COMPRESSION_DESC'                           => 'HTML Kompression entfernt unnötige Leerzeichen aus dem Code der Seiten, erschwert aber die Fehlerdiagnose.',
    'HTML_COMPRESSION_TITLE'                          => 'HTML Kompression einschalten',
    'HTTP_CACHING_DESC'                               => 'Durch Aktivieren des HTTP Cachings lädt der Browser die Javascripte des Shops nicht erneut vom Server herunter, wenn er diese bereits im Cache hat.',
    'HTTP_CACHING_TITLE'                              => 'HTTP Caching',
    'IMAGE_MANIPULATOR_DESC'                          => 'Image Manipulator für GD2 oder GD1',
    'IMAGE_MANIPULATOR_TITLE'                         => 'GDlib processing',
    'IMAGE_QUALITY_DESC'                              => 'Bildqualität (0 = höchste Kompression, 100 = beste Qualität) (Standard "75")',
    'IMAGE_QUALITY_TITLE'                             => 'Bildqualität',
    'IMAGE_REQUIRED_DESC'                             => 'Wenn du den Wert hier auf "1" setzt, werden nicht vorhandene Bilder als Rahmen angezeigt. Gut für Entwickler.',
    'IMAGE_REQUIRED_TITLE'                            => 'Bilder werden benötigt?',
    'LOG_CONFIGURATION_DESC'                          => 'Aktivieren und Deaktivieren von Logging-Ausgaben nach Ausgabe-Medium und Meldungstyp.',
    'LOG_CONFIGURATION_TITLE'                         => 'Ausgabe-Optionen',
    'LOG_SQL_BACKEND_DESC'                            => 'Datenbankverändernde SQL-Befehle im Backend werden geloggt.',
    'LOG_SQL_BACKEND_TITLE'                           => 'SQL-Logging im Backend',
    'LOG_SQL_FRONTEND_DESC'                           => 'Datenbankverändernde SQL-Befehle im Frontend werden geloggt.',
    'LOG_SQL_FRONTEND_TITLE'                          => 'SQL-Logging im Frontend',
    'LOGGING_ENABLED_DESC'                            => 'Logging im gesamten Shop aktivieren / deaktivieren',
    'LOGGING_ENABLED_TITLE'                           => 'Logging aktivieren',
    'LOGGING_GROUP'                                   => 'Logging-Gruppe',
    'LOGGING_LEVEL_ERROR'                             => 'Error',
    'LOGGING_LEVEL_NOTICE'                            => 'Notice',
    'LOGGING_LEVEL_WARNING'                           => 'Warning',
    'LOGGING_OUTPUT_BACKTRACE'                        => 'Backtrace',
    'LOGGING_OUTPUT_CLASS_DATA'                       => 'Klasse',
    'LOGGING_OUTPUT_CODE_SNIPPET'                     => 'Code',
    'LOGGING_OUTPUT_FILEPATH'                         => 'Dateipfade',
    'LOGGING_OUTPUT_FUNCTION_DATA'                    => 'Funktion',
    'LOGGING_OUTPUT_OUTPUT'                           => 'Ausgabe',
    'LOGGING_OUTPUT_REQUEST_DATA'                     => 'Request',
    'LOGGING_OUTPUT_SESSION_DATA'                     => 'Session',
    'LOGGING_OUTPUT_TYPE_FILE'                        => 'Datei',
    'LOGGING_OUTPUT_TYPE_HTML_FILE'                   => 'HTML-Datei',
    'LOGGING_OUTPUT_TYPE_MAIL'                        => 'Mail',
    'LOGGING_OUTPUT_TYPE_SCREEN'                      => 'Bildschirm',
    'MAX_ADDRESS_BOOK_ENTRIES_DESC'                   => 'Maximal erlaubte Anzahl an Adressbucheinträgen',
    'MAX_ADDRESS_BOOK_ENTRIES_TITLE'                  => 'Adressbucheinträge',
    'MAX_DISPLAY_ALSO_PURCHASED_DAYS_DESC'            => 'Zeitraum in Tagen, wie alt die Bestellung des ebenfalls gekauften Artikels sein darf.',
    'MAX_DISPLAY_ALSO_PURCHASED_DAYS_TITLE'           => 'Zeitraum (Tage) für ebenfalls gekaufte Artikel',
    'MAX_DISPLAY_ALSO_PURCHASED_DESC'                 => 'Maximale Anzahl der ebenfalls gekauften Artikel, die in der Artikeldetailansicht angezeigt werden sollen',
    'MAX_DISPLAY_ALSO_PURCHASED_TITLE'                => 'Ebenfalls gekauft',
    'MAX_DISPLAY_BESTSELLERS_DESC'                    => 'Maximale Anzahl an Bestsellern, die angezeigt werden sollen',
    'MAX_DISPLAY_BESTSELLERS_TITLE'                   => 'Maximale Anzahl an Bestsellern',
    'MAX_DISPLAY_CATEGORIES_PER_ROW_DESC'             => 'Anzahl an Kategorien, die pro Zeile in den Übersichten angezeigt werden sollen',
    'MAX_DISPLAY_CATEGORIES_PER_ROW_TITLE'            => 'Anzahl an Kategorien pro Zeile',
    'MAX_DISPLAY_CROSSSELLING_DESC'                   => 'Maximale Anzahl der Reverse Cross Marketing Artikel, die in der Box "Dieses Produkt ist z.B. kompatibel zu" in der Artikeldetailansicht angezeigt werden sollen',
    'MAX_DISPLAY_CROSSSELLING_TITLE'                  => 'Reverse Cross Marketing',
    'MAX_DISPLAY_MANUFACTURER_NAME_LEN_DESC'          => 'Hersteller-Box: Maximale Länge von Herstellernamen in der Hersteller-Box',
    'MAX_DISPLAY_MANUFACTURER_NAME_LEN_TITLE'         => 'Länge des Herstellernamens',
    'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST_DESC'        => 'Hersteller-Box: Wenn die Anzahl der Hersteller diesen Schwellenwert übersteigt, wird anstatt der üblichen Liste eine Drop-Down-Liste angezeigt.',
    'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST_TITLE'       => 'Hersteller-Liste Schwellenwert',
    'MAX_DISPLAY_NEW_PRODUCTS_DAYS_DESC'              => 'Zeitraum in Tagen, wie lange ein Artikel als neu gilt',
    'MAX_DISPLAY_NEW_PRODUCTS_DAYS_TITLE'             => 'Zeitraum (Tage) für neue Artikel',
    'MAX_DISPLAY_NEW_PRODUCTS_DESC'                   => 'Maximale Anzahl an neuen Artikeln, die in der Kategorieübersicht angezeigt werden sollen <img src="html/assets/images/legacy/gm_icons/warning.png" height="16" width="16" class="template_warning" />',
    'MAX_DISPLAY_NEW_PRODUCTS_TITLE'                  => 'Neue Artikel in Kategorieübersicht',
    'MAX_DISPLAY_NEW_REVIEWS_DESC'                    => 'Maximale Anzahl an neuen Bewertungen, die pro Seite angezeigt werden sollen',
    'MAX_DISPLAY_NEW_REVIEWS_TITLE'                   => 'Neue Bewertungen',
    'MAX_DISPLAY_ORDER_HISTORY_DESC'                  => 'Maximale Anzahl an Bestellungen, die in der Übersicht im Kundenbereich des Shops angezeigt werden sollen',
    'MAX_DISPLAY_ORDER_HISTORY_TITLE'                 => 'Bestellübersicht',
    'MAX_DISPLAY_PAGE_LINKS_DESC'                     => 'Anzahl der Einzelseiten, für die im Seitennavigationsmenü ein Link angezeigt werden soll',
    'MAX_DISPLAY_PAGE_LINKS_TITLE'                    => 'Seiten blättern - Einzelseiten',
    'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_DESC'  => 'Maximale Anzahl an Artikeln, die in der persönlichen Bestellübersichts-Box des Kunden angezeigt werden sollen',
    'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX_TITLE' => 'Bestellübersichts-Box',
    'MAX_DISPLAY_PRODUCTS_NEW_DESC'                   => 'Maximale Anzahl neuer Artikel, die in der Liste angezeigt werden sollen',
    'MAX_DISPLAY_PRODUCTS_NEW_TITLE'                  => 'Neue Artikel Liste',
    'MAX_DISPLAY_SEARCH_RESULTS_DESC'                 => 'Anzahl der Artikel, die in der Kategorie bzw. auf der Suchergebnisseite angezeigt werden',
    'MAX_DISPLAY_SEARCH_RESULTS_TITLE'                => 'Artikelanzahl in Kategorie / auf Suchergebnisseite',
    'MAX_DISPLAY_SPECIAL_PRODUCTS_DESC'               => 'Maximale Anzahl an Sonderangeboten, die angezeigt werden sollen',
    'MAX_DISPLAY_SPECIAL_PRODUCTS_TITLE'              => 'Sonderangebote',
    'MAX_DISPLAY_UPCOMING_PRODUCTS_DESC'              => 'Maximale Anzahl an angekündigten Artikeln, die auf der Startseite angezeigt werden sollen',
    'MAX_DISPLAY_UPCOMING_PRODUCTS_TITLE'             => 'Artikelankündigungen',
    'MAX_MANUFACTURERS_LIST_DESC'                     => 'Hersteller-Box: Wenn der Wert auf "1" gesetzt wird, wird die Hersteller-Box als Drop-Down-Liste angezeigt. Andernfalls als Liste (Wert auf "0").',
    'MAX_MANUFACTURERS_LIST_TITLE'                    => 'Hersteller-Liste',
    'MAX_PRODUCTS_QTY_DESC'                           => 'Maximale Menge, die je Artikel bestellt werden kann',
    'MAX_PRODUCTS_QTY_TITLE'                          => 'Maximale Bestellmenge je Artikel',
    'MAX_RANDOM_SELECT_NEW_DESC'                      => 'Aus wie vielen neuen Artikeln sollen die zufällig angezeigten neuen Artikel in der Box und auf der Startseite ausgewählt werden?',
    'MAX_RANDOM_SELECT_NEW_TITLE'                     => 'Auswahlpool der neuen Artikel',
    'MAX_RANDOM_SELECT_REVIEWS_DESC'                  => 'Aus wie vielen Bewertungen sollen die zufällig angezeigten Bewertungen in der Box ausgewählt werden?',
    'MAX_RANDOM_SELECT_REVIEWS_TITLE'                 => 'Auswahlpool der Bewertungen',
    'MAX_RANDOM_SELECT_SPECIALS_DESC'                 => 'Aus wie vielen Sonderangeboten sollen die zufällig angezeigten Sonderangebote in der Box und auf der Startseite ausgewählt werden?',
    'MAX_RANDOM_SELECT_SPECIALS_TITLE'                => 'Auswahlpool der Sonderangebote',
    'META_AUTHOR_DESC'                                => '<meta name="author">',
    'META_AUTHOR_TITLE'                               => 'author',
    'META_COMPANY_DESC'                               => '<meta name="company">',
    'META_COMPANY_TITLE'                              => 'company',
    'META_DESCRIPTION_DESC'                           => '<meta name="description">',
    'META_DESCRIPTION_TITLE'                          => 'Description',
    'META_KEYWORDS_DESC'                              => '<meta name="keywords">',
    'META_KEYWORDS_NUMBER_DESC'                       => 'Anzahl der Meta-Keywords',
    'META_KEYWORDS_NUMBER_TITLE'                      => 'Anzahl der Meta-Keywords',
    'META_KEYWORDS_TITLE'                             => 'Keywords',
    'META_MIN_KEYWORD_LENGTH_DESC'                    => 'Minimum Länge der automatisch erzeugten Meta-Keywords (Artikelbeschreibung)',
    'META_MIN_KEYWORD_LENGTH_TITLE'                   => 'Minimum Länge Meta-Keywords',
    'META_PUBLISHER_DESC'                             => '<meta name="publisher">',
    'META_PUBLISHER_TITLE'                            => 'publisher',
    'META_REPLY_TO_DESC'                              => '<meta name="reply-to">',
    'META_REPLY_TO_TITLE'                             => 'reply-to',
    'META_REVISIT_AFTER_DESC'                         => '<meta name="revisit-after">',
    'META_REVISIT_AFTER_TITLE'                        => 'revisit-after',
    'META_ROBOTS_DESC'                                => '<meta name="robots">',
    'META_ROBOTS_TITLE'                               => 'robots',
    'META_TOPIC_DESC'                                 => '<meta name="page-topic">',
    'META_TOPIC_TITLE'                                => 'page-topic',
    'MIN_DISPLAY_ALSO_PURCHASED_DESC'                 => 'Minimum Anzahl der ebenfalls gekauften Artikel, die bei der Artikelansicht angezeigt werden sollen',
    'MIN_DISPLAY_ALSO_PURCHASED_TITLE'                => 'Ebenfalls gekauft',
    'MIN_DISPLAY_BESTSELLERS_DESC'                    => 'Minimale Anzahl an Bestsellern, die angezeigt werden sollen',
    'MIN_DISPLAY_BESTSELLERS_TITLE'                   => 'Minimale Anzahl an Bestsellern',
    'MO_PICS_DESC'                                    => 'Anzahl der Artikelbilder, die zusätzlich zum Haupt-Artikelbild zur Verfügung stehen sollen',
    'MO_PICS_TITLE'                                   => 'Anzahl zusätzlicher Artikelbilder',
    'MODULE_ORDER_TOTAL_INSTALLED_DESC'               => 'Liste der Order-Total-Modul-Dateinamen (getrennt durch einen Strichpunkt (;)). Diese wird automatisch aktualisiert, daher ist es nicht notwendig diese zu editieren. (Beispiel: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)',
    'MODULE_ORDER_TOTAL_INSTALLED_TITLE'              => 'Installierte Order Total-Module',
    'MODULE_PAYMENT_INSTALLED_DESC'                   => 'Liste der Zahlungsmodul-Dateinamen (getrennt durch einen Strichpunkt (;)). Diese wird automatisch aktualisiert, daher ist es nicht notwendig diese zu editieren. (Beispiel: cc.php;cod.php;paypal.php)',
    'MODULE_PAYMENT_INSTALLED_TITLE'                  => 'Installierte Zahlungsmodule',
    'MODULE_SHIPPING_INSTALLED_DESC'                  => 'Liste der Versandmodul-Dateinamen (getrennt durch einen Strichpunkt (;)). Diese wird automatisch aktualisiert, daher ist es nicht notwendig diese zu editieren. (Beispiel: ups.php;flat.php;item.php)',
    'MODULE_SHIPPING_INSTALLED_TITLE'                 => 'Installierte Versand Module',
    'MOVE_ONLY_IF_NO_GUEST_TITLE'                     => 'Gäste verschieben wenn "Kundengruppe nach USt-IdNr. Überprüfung anpassen" aktiv ist',
    'PAYPAL_API_PWD_DESC'                             => 'trage hier das Passwort ein',
    'PAYPAL_API_PWD_TITLE'                            => 'PayPal-API-Passwort (Live)',
    'PAYPAL_API_SANDBOX_PWD_DESC'                     => 'trage hier das Passwort ein',
    'PAYPAL_API_SANDBOX_PWD_TITLE'                    => 'PayPal-API-Passwort (Sandbox)',
    'PAYPAL_API_SANDBOX_SIGNATURE_DESC'               => 'trage hier die API Signatur ein',
    'PAYPAL_API_SANDBOX_SIGNATURE_TITLE'              => 'PayPal-API-Signatur (Sandbox)',
    'PAYPAL_API_SANDBOX_USER_DESC'                    => 'trage hier den Benutzernamen ein',
    'PAYPAL_API_SANDBOX_USER_TITLE'                   => 'PayPal-API-Benutzer (Sandbox)',
    'PAYPAL_API_SIGNATURE_DESC'                       => 'trage hier die API Signatur ein',
    'PAYPAL_API_SIGNATURE_TITLE'                      => 'PayPal-API-Signatur (Live)',
    'PAYPAL_API_USER_DESC'                            => 'trage hier den Benutzernamen ein',
    'PAYPAL_API_USER_TITLE'                           => 'PayPal-API-Benutzer (Live)',
    'PAYPAL_COUNTRY_MODE_DESC'                        => 'wähle hier die Einstellung für den Ländermodus. Verschiedene Funktionen von PayPal sind nur in UK möglich (z.b. DirectPayment )',
    'PAYPAL_COUNTRY_MODE_TITLE'                       => 'PayPal-Ländermodus',
    'PAYPAL_ERROR_EMAIL_ADDRESS_DESC'                 => 'trage hier die Emailadresse ein',
    'PAYPAL_ERROR_EMAIL_ADDRESS_TITLE'                => 'PayPal-Fehler-Emailadresse',
    'PAYPAL_EXPRESS_ADDRESS_CHANGE_DESC'              => 'Erlaubt den Kunden, die von PayPal übermittelten Adressdaten zu ändern',
    'PAYPAL_EXPRESS_ADDRESS_CHANGE_TITLE'             => 'PayPal-Express-Adressdaten',
    'PAYPAL_EXPRESS_ADDRESS_OVERRIDE_DESC'            => 'Erlaubt PayPal, eine neue Lieferadresse für den Kunden zu übermittelten. Diese wird dann ausgewählt (bestehendes Konto)',
    'PAYPAL_EXPRESS_ADDRESS_OVERRIDE_TITLE'           => 'Lieferadresse überschreiben',
    'PAYPAL_EXPRESS_PAYMENTACTION_DESC'               => 'Wähle hier die PayPal-Express-Methode aus.<br /><strong>Sale</strong> - Schließt die Transaktion sofort ab.<br /><strong>Authorization</strong> - Transaktion bleibt im Status offen und muss nachträglich eingezogen werden. Teilbeträge sind möglich.<br /><strong>Order</strong> - Transaktion bleibt im Status offen und muss nachträglich eingezogen werden. Teilbeträge sind <strong>NICHT</strong> möglich',
    'PAYPAL_EXPRESS_PAYMENTACTION_TITLE'              => 'PayPal-Express-Methoden',
    'PAYPAL_MODE_DESC'                                => 'Live oder Testbetrieb',
    'PAYPAL_MODE_TITLE'                               => 'PayPal-Modus:',
    'PAYPAL_ORDER_STATUS_PENDING_ID_DESC'             => 'wähle den Bestellstatus für eine Transaktion aus, die noch nicht von Paypal bearbeitet wurde',
    'PAYPAL_ORDER_STATUS_PENDING_ID_TITLE'            => 'Bestellstatus "in Bearbeitung"',
    'PAYPAL_ORDER_STATUS_REJECTED_ID_DESC'            => 'wähle den Bestellstatus für eine abgelehnte Transaktion aus',
    'PAYPAL_ORDER_STATUS_REJECTED_ID_TITLE'           => 'Bestellstatus "abgewiesen"',
    'PAYPAL_ORDER_STATUS_SUCCESS_ID_DESC'             => 'wähle den Bestellstatus für eine erfolgreiche Transaktion aus',
    'PAYPAL_ORDER_STATUS_SUCCESS_ID_TITLE'            => 'Bestellstatus OK',
    'PAYPAL_ORDER_STATUS_TMP_ID_DESC'                 => 'wähle den temporären Bestellstatus aus',
    'PAYPAL_ORDER_STATUS_TMP_ID_TITLE'                => 'Temporärer Bestellstatus',
    'PAYPAL_SHOP_LOGO_DESC'                           => 'Die URL deines Shop Logos, das am oberen linken Rand des PayPal-Warenkorbs angezeigt wird.<br />Das Bild darf eine maximale Größe von 750 Pixel Breite und 90 Pixel Höhe nicht überschreiten.<br />Z.B. ',
    'PAYPAL_SHOP_LOGO_TITLE'                          => 'Shop Logo',
    'PREFER_GZHANDLER_DESC'                           => 'Aktiviere diese Option, wenn die GZip-Kompression standardmäßig nicht funktioniert.',
    'PREFER_GZHANDLER_TITLE'                          => 'ob_gzhandler bevorzugen',
    'PRICE_IS_BRUTTO_DESC'                            => 'Artikelpreise werden entweder brutto ("Ja") oder netto ("Nein") eingetragen.',
    'PRICE_IS_BRUTTO_TITLE'                           => 'Brutto Preisangaben im Gambio Admin?',
    'PRICE_PRECISION_DESC'                            => 'Anzahl der Dezimalstellen, die intern gespeichert werden. Standard ist 4 und sollte nicht geändert werden, da ansonsten Ungenauigkeiten bei Brutto/Netto-Umrechnungen entstehen können.',
    'PRICE_PRECISION_TITLE'                           => 'Umrechnungsgenauigkeit für Dezimalstellen',
    'PRODUCT_IMAGE_INFO_HEIGHT_DESC'                  => 'Maximale Höhe der Artikel-Info Bilder in Pixeln',
    'PRODUCT_IMAGE_INFO_HEIGHT_TITLE'                 => 'Höhe der Artikel-Info Bilder',
    'PRODUCT_IMAGE_INFO_WIDTH_DESC'                   => 'Maximale Breite der Artikel-Info Bilder in Pixeln',
    'PRODUCT_IMAGE_INFO_WIDTH_TITLE'                  => 'Breite der Artikel-Info Bilder',
    'PRODUCT_IMAGE_POPUP_HEIGHT_DESC'                 => 'Maximale Höhe der Artikel-Popup Bilder in Pixeln',
    'PRODUCT_IMAGE_POPUP_HEIGHT_TITLE'                => 'Höhe der Artikel-Popup Bilder',
    'PRODUCT_IMAGE_POPUP_WIDTH_DESC'                  => 'Maximale Breite der Artikel-Popup Bilder in Pixeln',
    'PRODUCT_IMAGE_POPUP_WIDTH_TITLE'                 => 'Breite der Artikel-Popup Bilder',
    'PRODUCT_IMAGE_THUMBNAIL_HEIGHT_DESC'             => 'Maximale Höhe der Artikel-Thumbnails in Pixeln',
    'PRODUCT_IMAGE_THUMBNAIL_HEIGHT_TITLE'            => 'Höhe der Artikel-Thumbnails',
    'PRODUCT_IMAGE_THUMBNAIL_WIDTH_DESC'              => 'Maximale Breite der Artikel-Thumbnails in Pixeln',
    'PRODUCT_IMAGE_THUMBNAIL_WIDTH_TITLE'             => 'Breite der Artikel-Thumbnails',
    'PRODUCT_LIST_FILTER_DESC'                        => 'Anzeige des Kategorie- bzw. Hersteller-Dropdowns in der Artikelübersicht (0 = inaktiv; 1 = aktiv)',
    'PRODUCT_LIST_FILTER_TITLE'                       => 'Hersteller- und Kategorie-Filter anzeigen?',
    'PRODUCT_REVIEWS_VIEW_DESC'                       => 'Anzahl der angezeigten Bewertungen in der Artikeldetailansicht',
    'PRODUCT_REVIEWS_VIEW_TITLE'                      => 'Bewertungen in Artikeldetailansicht',
    'QUICKLINK_ACTIVATED_DESC'                        => 'Erleichtert das Kopieren/Verlinken eines Artikels in mehrere Kategorien, durch die Möglichkeit, einzelne Kategorien per Auswahlbox zu selektieren.',
    'QUICKLINK_ACTIVATED_TITLE'                       => 'Verlinken/Kopieren aktivieren',
    'REVIEW_TEXT_MIN_LENGTH_DESC'                     => 'Mindestlänge der Texteingabe bei Bewertungen',
    'REVIEW_TEXT_MIN_LENGTH_TITLE'                    => 'Bewertungen',
    'REVOCATION_ID_DESC'                              => 'Content-ID des Widerrufsrechts (Sprachgruppe der Widerrufsrecht Seite im Content Manager)',
    'REVOCATION_ID_TITLE'                             => 'Widerrufsrecht Content-ID',
    'SEARCH_ENGINE_FRIENDLY_URLS_DESC'                => 'Die Seiten-URLs können automatisch für Suchmaschinen optimiert angezeigt werden. Dazu muss dein Server mod_rewrite unterstützen.<br /><br /><strong>Diese Option kann nur aktiviert werden, wenn du die Gambio SEO Boost Urls nicht nutzt.</strong></span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren bist und du sich sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'SEARCH_ENGINE_FRIENDLY_URLS_TITLE'               => 'Suchmaschinenfreundliche URLs benutzen?',
    'SEARCH_IN_ATTR_DESC'                             => 'Aktivieren, um die Suche in den Artikeloptionen und Artikelvarianten (z. B. Farbe, Länge) zu ermöglichen',
    'SEARCH_IN_ATTR_TITLE'                            => 'Suche in Artikeloptionen/Artikelvarianten',
    'SEARCH_IN_DESC_DESC'                             => 'Aktivieren, um die Suche in den Artikelbeschreibungen (kurz und lang) zu ermöglichen',
    'SEARCH_IN_DESC_TITLE'                            => 'Suche in Artikelbeschreibungen',
    'SECURITY_CODE_LENGTH_DESC'                       => 'Länge des Sicherheitscodes (Geschenk-Gutschein)',
    'SECURITY_CODE_LENGTH_TITLE'                      => 'Länge des Sicherheitscodes',
    'SEND_EMAIL_BY_BILLING_ADRESS_DESC'               => 'Solltest du keine Bestellbestätigungsmails erhalten, stelle diesen Schalter auf <b>Betreiber E-Mail</b>.</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Prüfe zuvor mit einer Testbestellung, ob generell Bestätigungsmails versendet werden, bevor du hier Einstellungen vornimmst!',
    'SEND_EMAIL_BY_BILLING_ADRESS_TITLE'              => 'Absender der Bestellbestätigungsmail',
    'SEND_EMAILS_DESC'                                => 'Betrifft nur E-Mails, die automatisch vom System verschickt werden (Kundenkontoerstellung, Bestellbestätigung).',
    'SEND_EMAILS_TITLE'                               => 'Senden von E-Mails',
    'SEND_EXTRA_ORDER_E-MailS_TO_DESC'                => 'Wenn zusätzlich eine Kopie der Bestell-E-Mails versendet werden soll, bitte in dieser Weise die Empfangs-Adressen auflisten: Name 1 <E-Mail@adresse1>, Name 2 <E-Mail@adresse2>',
    'SEND_EXTRA_ORDER_E-MailS_TO_TITLE'               => 'Senden einer extra Bestell-E-Mail an:',
    'SENDMAIL_PATH_DESC'                              => 'Wenn du Sendmail benutzt, gib hier den Pfad zum Sendmail Programm an (normalerweise: /usr/sbin/sendmail).',
    'SENDMAIL_PATH_TITLE'                             => 'Pfad zu Sendmail',
    'SESSION_CHECK_IP_ADDRESS_DESC'                   => 'bei jedem Seitenaufruf die IP-Adresse des Users überprüfen (Standard "nein")',
    'SESSION_CHECK_IP_ADDRESS_TITLE'                  => 'Überprüfen der IP-Adresse',
    'SESSION_CHECK_SSL_SESSION_ID_DESC'               => 'Überprüfen der SSL_SESSION_ID bei jedem HTTPS Seitenaufruf (Standard "nein")</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren und dir sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'SESSION_CHECK_SSL_SESSION_ID_TITLE'              => 'Überprüfen der SSL Session ID',
    'SESSION_CHECK_USER_AGENT_DESC'                   => 'bei jedem Seitenaufruf überprüfen, welchen Browser der User benutzt (Standard "nein")</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren und dir sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'SESSION_CHECK_USER_AGENT_TITLE'                  => 'Überprüfen des User Browsers',
    'SESSION_FORCE_COOKIE_USE_DESC'                   => 'Session starten, falls Cookies vom Browser erlaubt werden (Standard "nein")</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren und dir sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'SESSION_FORCE_COOKIE_USE_TITLE'                  => 'Cookie Benutzung bevorzugen',
    'SESSION_RECREATE_DESC'                           => 'Erneuern der Session und Zuweisung einer neuen Session ID, sobald sich ein User einloggt oder registriert hat (PHP >= 4.1 benötigt) (Standard "nein")</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren und dir sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'SESSION_RECREATE_TITLE'                          => 'Session erneuern',
    'SESSION_TIMEOUT_DESC'                            => 'Legt die Dauer in Minuten fest, wie lange eine Session im Gambio Admin gültig ist. Nach Ablauf dieser festgelegten Zeit wird die Session entfernt und eine erneute Anmeldung ist erforderlich!</span>',
    'SESSION_TIMEOUT_TITLE'                           => 'Session Gültigkeitsdauer',
    'SESSION_KEEP_ALIVE_DESC'                         => 'Hält die aktuelle Session bis zum Logout aktiv.',
    'SESSION_KEEP_ALIVE_TITLE'                        => 'Session aktiv halten',
    'SHIPPING_BOX_PADDING_DESC'                       => 'Für etwa 10% gib 10 ein.',
    'SHIPPING_BOX_PADDING_TITLE'                      => 'Bei größeren Leerpaketen - Gewichtszuwachs in %',
    'SHIPPING_BOX_WEIGHT_DESC'                        => 'Wie hoch ist das Gewicht eines durchschnittlichen kleinen bis mittleren Leerpaketes?',
    'SHIPPING_BOX_WEIGHT_TITLE'                       => 'Paketleergewicht',
    'SHIPPING_MAX_WEIGHT_DESC'                        => 'Versandpartner (Deutsche Post, UPS etc.) haben ein maximales Paketgewicht. Gib einen Wert dafür ein (kg).',
    'SHIPPING_MAX_WEIGHT_TITLE'                       => 'Maximalgewicht, das als ein Paket versendet werden kann',
    'SHIPPING_ORIGIN_COUNTRY_DESC'                    => 'Wähle für die Berechnung korrekter Versandgebühren das Versandland aus.',
    'SHIPPING_ORIGIN_COUNTRY_TITLE'                   => 'Versandland',
    'SHIPPING_ORIGIN_ZIP_DESC'                        => 'Bitte gib die Postleitzahl des Versandstandortes ein.',
    'SHIPPING_ORIGIN_ZIP_TITLE'                       => 'Postleitzahl des Versandstandortes',
    'SHOW_CART_SHIPPING_COSTS_DESC'                   => 'Hinter dem Versandkostenhinweis erscheint ein Icon, über das der Versandkostenrechner aufgerufen werden kann.',
    'SHOW_CART_SHIPPING_COSTS_TITLE'                  => 'Versandkostenrechner im Warenkorb',
    'SHOW_CART_SHIPPING_WEIGHT_DESC'                  => 'Versandgewicht im Warenkorb anzeigen.',
    'SHOW_CART_SHIPPING_WEIGHT_TITLE'                 => 'Versandgewicht im Warenkorb',
    'SHOW_COUNTS_DESC'                                => 'Zählt die Anzahl der verschiedenen Artikel pro Kategorie und enthaltener Unterkategorien, und zeigt die Anzahl (x) hinter jedem Kategorienamen an.</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Bei Aktivierung dieser Option können die Performance und Ladezeit stark beeinträchtigt werden',
    'SHOW_COUNTS_TITLE'                               => 'Artikelanzahl hinter Kategorienamen?',
    'SHOW_IP_LOG_DESC'                                => 'Text "Ihre IP wird aus Sicherheitsgründen gespeichert" nach Abschluss der Bestellung anzeigen?',
    'SHOW_IP_LOG_TITLE'                               => 'IP-Speicherung anzeigen?',
    'SHOW_SHIPPING_DESC'                              => 'verlinkte Anzeige von "zzgl. Versandkosten" in den Artikelinformationen.',
    'SHOW_SHIPPING_TITLE'                             => 'Versandkosten in Artikelinfos',
    'SHOW_FULL_SHIPPING_COUNTRY_NAME_DESC'            => 'Versandland wird mit vollem Namen im Warenkorb statt Abkürzung (ISO-Code) angezeigt',
    'SHOW_FULL_SHIPPING_COUNTRY_NAME_TITLE'           => 'Versandland im Warenkorb mit vollem Namen statt Abkürzung anzeigen',
    'SHOW_UNTRANSLATED_MENUITEMS_DESC'                => 'Menüeintrage ohne Übersetzung im Administationsbereich anzeigen (Im Anschluß bitte Modul-Cache leeren).',
    'SHOW_UNTRANSLATED_MENUITEMS_TITLE'               => 'Menüeintrage ohne Übersetzung',
    'SMALL_IMAGE_HEIGHT_DESC'                         => 'Maximale Höhe der Artikel Bilderin Pixeln',
    'SMALL_IMAGE_HEIGHT_TITLE'                        => 'Höhe der Artikel Bilder',
    'SMALL_IMAGE_WIDTH_DESC'                          => 'Maximale Breite der Artikel Bilder in Pixeln',
    'SMALL_IMAGE_WIDTH_TITLE'                         => 'Breite der Artikel Bilder',
    'SMTP_AUTH_DESC'                                  => 'Erfordert der SMTP Server eine sichere Authentifizierung?',
    'SMTP_AUTH_TITLE'                                 => 'SMTP AUTH',
    'SMTP_BACKUP_SERVER_DESC'                         => 'Gib hier die Adresse deines Backup SMTP Servers ein.',
    'SMTP_BACKUP_SERVER_TITLE'                        => 'Adresse des SMTP Backup Servers',
    'SMTP_ENCRYPTION_DESC'                            => 'Wähle hier die Art der SMTP-Verschlüsselung aus.',
    'SMTP_ENCRYPTION_TITLE'                           => 'SMTP Verschlüsselung',
    'SMTP_MAIN_SERVER_DESC'                           => 'Gib hier die Adresse deines Haupt SMTP Servers ein.',
    'SMTP_MAIN_SERVER_TITLE'                          => 'Adresse des SMTP Servers',
    'SMTP_PASSWORD_DESC'                              => 'Bitte gib hier das Passwort deines SMTP Accounts ein.',
    'SMTP_PASSWORD_TITLE'                             => 'SMTP Passwort',
    'SMTP_PORT_DESC'                                  => 'Gib hier den SMTP Port deines SMTP Servers ein (Standard: 25).',
    'SMTP_PORT_TITLE'                                 => 'SMTP Port',
    'SMTP_USERNAME_DESC'                              => 'Bitte gib hier den Usernamen deines SMTP Accounts ein.',
    'SMTP_USERNAME_TITLE'                             => 'SMTP Username',
    'SQL_LOG_MAX_FILESIZE_DESC'                       => 'Maximale Dateigröße der SQL-Logging-Datei in MB. Wird das Limit überschritten, wird die Log-Datei unter neuem Namen im gz-Format komprimiert angelegt.',
    'SQL_LOG_MAX_FILESIZE_TITLE'                      => 'Maximale Dateigröße',
    'STOCK_ALLOW_CHECKOUT_DESC'                       => 'Sollen Bestellungen auch dann möglich sein, wenn bestimmte Artikel laut Lagerbestand nicht verfügbar sind?',
    'STOCK_ALLOW_CHECKOUT_TITLE'                      => 'Einkaufen nicht vorrätiger Artikel erlauben',
    'STOCK_CHECK_DESC'                                => 'Prüfen, ob die Artikel in angeforderter Menge auf Lager sind, um Bestellung ausführen zu können?',
    'STOCK_CHECK_TITLE'                               => 'Überprüfen des Artikelbestandes',
    'STOCK_LIMITED_DESC'                              => 'Artikelmenge vom Artikelbestand abziehen, wenn der Artikel bestellt wurde?',
    'STOCK_LIMITED_TITLE'                             => 'Artikelmenge abziehen',
    'STOCK_MARK_PRODUCT_OUT_OF_STOCK_DESC'            => 'Kennzeichnung vergriffener Artikel, um dem Kunden kenntlich zu machen, welche Artikel nicht mehr verfügbar sind.',
    'STOCK_MARK_PRODUCT_OUT_OF_STOCK_TITLE'           => 'Kennzeichnung vergriffener Artikel',
    'STOCK_REORDER_LEVEL_DESC'                        => 'Ab welcher Stückzahl soll diese Meldung erscheinen?',
    'STOCK_REORDER_LEVEL_TITLE'                       => 'Meldung an den Shopbetreiber, dass ein Artikel nachbestellt werden muss',
    'STORE_COUNTRY_DESC'                              => 'Das Land, aus dem der Versand erfolgt.<br /><br /><strong>Hinweis: Bitte nicht vergessen, die Region richtig anzupassen.</strong>',
    'STORE_COUNTRY_TITLE'                             => 'Land',
    'STORE_DB_TRANSACTIONS_DESC'                      => 'Speichern der einzelnen Datenbankabfragen in der Logdatei für Berechnungszeiten',
    'STORE_DB_TRANSACTIONS_TITLE'                     => 'Speichern aller Datenbankabfragen',
    'STORE_NAME_ADDRESS_DESC'                         => 'Trage hier deine Geschäftsadresse, wie in einem Briefkopf, ein.',
    'STORE_NAME_ADDRESS_TITLE'                        => 'Geschäftsadresse und Telefonnummer etc.',
    'STORE_NAME_DESC'                                 => 'Der Name dieses Onlineshops, der als Titel angezeigt wird.',
    'STORE_NAME_TITLE'                                => 'Name des Shops',
    'STORE_OWNER_DESC'                                => 'Der Name des Shopbetreibers',
    'STORE_OWNER_EMAIL_ADDRESS_DESC'                  => 'Die E-Mail-Adresse des Shopbetreibers',
    'STORE_OWNER_EMAIL_ADDRESS_TITLE'                 => 'E-Mail-Adresse',
    'STORE_OWNER_TITLE'                               => 'Inhaber',
    'STORE_OWNER_VAT_ID_DESC'                         => 'Die USt-IdNr. des Shopbetreibers',
    'STORE_OWNER_VAT_ID_TITLE'                        => 'USt-IdNr. des Shopbetreibers',
    'STORE_PAGE_PARSE_TIME_DESC'                      => 'Speichern der Zeit, die benötigt wird, um Scripte bis zur Ausgabe der Seite zu berechnen',
    'STORE_PAGE_PARSE_TIME_LOG_DESC'                  => 'Absoluten Verzeichnispfad mit Dateinamen der Logdatei eintragen (Standard "/var/log/www/tep/page_parse_time.log")',
    'STORE_PAGE_PARSE_TIME_LOG_TITLE'                 => 'Speicherort der Logdatei der Berechnungszeit',
    'STORE_PAGE_PARSE_TIME_TITLE'                     => 'Speichern der Berechnungszeit der Seite',
    'STORE_ZONE_DESC'                                 => 'Die Region des Landes, aus dem der Versand erfolgt.',
    'STORE_ZONE_TITLE'                                => 'Region',
    'SUBCATEGORY_IMAGE_HEIGHT_DESC'                   => 'Maximale Höhe der Subkategorie-(Warengruppen-) Bilder in Pixeln',
    'SUBCATEGORY_IMAGE_HEIGHT_TITLE'                  => 'Höhe der Subkategorie-(Warengruppen-) Bilder',
    'SUBCATEGORY_IMAGE_WIDTH_DESC'                    => 'Maximale Breite der Subkategorie-(Warengruppen-) Bilder in Pixeln',
    'SUBCATEGORY_IMAGE_WIDTH_TITLE'                   => 'Breite der Subkategorie-(Warengruppen-) Bilder',
    'TABLE_HEADING_ACTION'                            => 'Aktion',
    'TABLE_HEADING_CONFIGURATION_TITLE'               => 'Name',
    'TABLE_HEADING_CONFIGURATION_VALUE'               => 'Wert',
    'TEXT_INFO_DATE_ADDED'                            => 'hinzugefügt am:',
    'TEXT_INFO_EDIT_INTRO'                            => 'Bitte führe alle notwendigen Änderungen durch',
    'TEXT_INFO_LAST_MODIFIED'                         => 'letzte Änderung:',
    'TRADER_FAX_DESC'                                 => 'Die Faxnummer des Shopbetreibers',
    'TRADER_FAX_TITLE'                                => 'Faxnummer',
    'TRADER_FIRSTNAME_DESC'                           => 'Der Vorname des Shopbetreibers',
    'TRADER_FIRSTNAME_TITLE'                          => 'Vorname',
    'TRADER_LOCATION_DESC'                            => 'Der Ort des Firmensitzes',
    'TRADER_LOCATION_TITLE'                           => 'Ort',
    'TRADER_NAME_DESC'                                => 'Der Nachname des Shopbetreibers',
    'TRADER_NAME_TITLE'                               => 'Nachname',
    'TRADER_STREET_DESC'                              => 'Der Straßenname des Firmensitzes',
    'TRADER_STREET_NUMBER_DESC'                       => 'Die Hausnummer des Firmensitzes',
    'TRADER_STREET_NUMBER_TITLE'                      => 'Hausnummer',
    'TRADER_STREET_TITLE'                             => 'Straßenname',
    'TRADER_TEL_DESC'                                 => 'Die Telefonnummer des Shopbetreibers',
    'TRADER_TEL_TITLE'                                => 'Telefonnummer',
    'TRADER_ZIPCODE_DESC'                             => 'Die Postleitzahl des Firmensitzes',
    'TRADER_ZIPCODE_TITLE'                            => 'Postleitzahl',
    'UNFOLD_FAVS_BOX_DESC'                            => '',
    'UNFOLD_FAVS_BOX_TITLE'                           => 'Favoritenbox immer ausgeklappt',
    'UPDATE_ORDER_EMAIL_SUBJECT_TEXT'                 => 'Ihre Bestellung',
    'USE_BUSTFILES_TITLE'                             => 'Cache-freundliche Dateinamen',
    'USE_BUSTFILES_DESC'                              => 'Für bestimmte Ressourcen (Javascript, CSS) kann ein Cache-Busting-Parameter im Dateinamen oder als Query-String-Parameter verwendet werden. Setzt wirksame Rewriting-Regeln aus der zentralen .htaccess-Datei voraus! Kann notfalls über login_admin.php?repair=bustfiles abgeschaltet werden.',
    'USE_CACHE_DESC'                                  => 'Sollen die Shopseiten im Cache gespeichert werden (bei langsamen Servern oder hoher Artikelanzahl sinnvoll, um Ladezeiten zu verringern)?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren bist und du sich sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'USE_CACHE_TITLE'                                 => 'Cache benutzen',
    'USE_DEFAULT_LANGUAGE_CURRENCY_DESC'              => 'Wenn die Spracheinstellung gewechselt wird, wird automatisch die Währung angepasst.',
    'USE_DEFAULT_LANGUAGE_CURRENCY_TITLE'             => 'Automatisch auf Landeswährung umstellen',
    'USE_WYSIWYG_DESC'                                => 'WYSIWYG-Editor im Gambio Admin als Standard-Editor aktivieren?',
    'USE_WYSIWYG_TITLE'                               => 'WYSIWYG-Editor aktivieren',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_DESC'           => 'Überprüft den Lagerbestand bereits auf der Artikeldetails-Seite.',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_TITLE'          => 'Lagerbestand vor dem Warenkorb prüfen?',
    'COMPANY_NAME_DESC'                               => 'Gib hier deine Firmennamen ein.',
    'SHIPPING_INFOS_DESC'                             => 'Sprachgruppen ID der Versandkosten-Informationsseite (Standard "1") für die Verlinkung (z. B. Link unter Preisangabe: zzgl. Versand).',
    'SHIPPING_INFOS_TITLE'                            => 'Versandkosten Content Seiten ID',
    'TRADER_TEL_DESC'                                 => 'Die Telefonnummer des Shop-Betreibers',
    'TRADER_TEL_TITLE'                                => 'Telefonnummer',
    'TRADER_ZIPCODE_DESC'                             => 'Die Postleitzahl des Firmensitzes',
    'TRADER_ZIPCODE_TITLE'                            => 'Postleitzahl',
    'UNFOLD_FAVS_BOX_DESC'                            => '',
    'UNFOLD_FAVS_BOX_TITLE'                           => 'Favoritenbox immer ausgeklappt',
    'UPDATE_ORDER_EMAIL_SUBJECT_TEXT'                 => 'Ihre Bestellung',
    'USE_BUSTFILES_TITLE'                             => 'Cache-freundliche Dateinamen',
    'USE_BUSTFILES_DESC'                              => 'Für bestimmte Ressourcen (Javascript, CSS) kann ein Cache-Busting-Parameter im Dateinamen oder als Query-String-Parameter verwendet werden. Setzt wirksame Rewriting-Regeln aus der zentralen .htaccess-Datei voraus! Kann notfalls über login_admin.php?repair=bustfiles abgeschaltet werden.',
    'USE_CACHE_DESC'                                  => 'Sollen die Shopseiten im Cache gespeichert werden (bei langsamen Servern oder hoher Artikelanzahl sinnvoll, um Ladezeiten zu verringern)?</span><span class="tooltip-icon" data-gx-widget="tooltip_icon" data-tooltip_icon-type="warning">Diese Funktion kann die Funktionsfähigkeit des Shops unter Umständen beeinflussen. Bitte führe hier nur Änderungen durch, wenn du dir über die möglichen Folgen im Klaren bist und du sich sicher bist, dass diese Funktion vom Server unterstützt wird!',
    'USE_CACHE_TITLE'                                 => 'Cache benutzen',
    'USE_DEFAULT_LANGUAGE_CURRENCY_DESC'              => 'Wenn die Spracheinstellung gewechselt wird, wird automatisch die Währung angepasst.',
    'USE_DEFAULT_LANGUAGE_CURRENCY_TITLE'             => 'Automatisch auf Landeswährung umstellen',
    'USE_WYSIWYG_DESC'                                => 'WYSIWYG-Editor im Gambio Admin als Standard-Editor aktivieren?',
    'USE_WYSIWYG_TITLE'                               => 'WYSIWYG-Editor aktivieren',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_DESC'           => 'Überprüft den Lagerbestand bereits auf der Artikeldetails Seite.',
    'CHECK_STOCK_BEFORE_SHOPPING_CART_TITLE'          => 'Lagerbestand vor dem Warenkorb prüfen?',
    'COMPANY_NAME_DESC'                               => 'Gib hier deinen Firmennamen ein.',
    'SHIPPING_INFOS_DESC'                             => 'Sprachgruppen ID der Versandkosten-Informationsseite (Standard "1") für die Verlinkung (z. B. Link unter Preisangabe: zzgl. Versand).',
    'SHIPPING_INFOS_TITLE'                            => 'Versandkosten Content Seiten ID',
    'NUMBER_OF_CUSTOMERS_PER_PAGE_TITLE'              => 'Anzahl Kunden pro Seite',
    'NUMBER_OF_CUSTOMERS_PER_PAGE_DESC'               => 'Wie viele Kunden sollen in der Übersicht pro Seite im Gambio Admin angezeigt werden?',
    'NUMBER_OF_ORDERS_PER_PAGE_TITLE'                 => 'Anzahl Bestellungen pro Seite',
    'NUMBER_OF_ORDERS_PER_PAGE_DESC'                  => 'Wie viele Bestellungen sollen in der Übersicht pro Seite im Gambio Admin angezeigt werden',
    'NUMBER_OF_PRODUCTS_PER_PAGE_TITLE'               => 'Anzahl Artikel pro Seite',
    'NUMBER_OF_PRODUCTS_PER_PAGE_DESC'                => 'Wie viele Artikel sollen in der Übersicht pro Seite im Gambio Admin angezeigt werden',
    'USE_APILAYER_API_KEY_TITLE'                      => 'APILayer API-Key für Wechselkursaktualisierung',
    'USE_APILAYER_API_KEY_DESC'                       => 'Um Wechselkurse aktualisieren zu können, benötigst du einen APILayer-Account, den du unter https://apilayer.com erstellen kannst. Im Account findest du den API-Key, der hier eingetragen werden muss. Außerdem musst du die Exchange Rates Data API https://apilayer.com/marketplace/exchangerates_data-api abonniert haben (kostenlos möglich).',
    'SERVICE_WITHOUT_SHIPPING_TITLE'                  => 'Versandartauswahl bei Dienstleistungen überspringen',
    'SERVICE_WITHOUT_SHIPPING_DESC'                   => 'Wenn sich im Warenkorb nur Dienstleistungsartikel befinden, wird die Auswahl der Versandart im Bestellvorgang übersprungen',
    'SHOW_SHIPPING_WEIGHT_CHECKOUT_TITLE'             => 'Versandgewicht im Bestellvorgang bei allen Versandmodule anzeigen',
    'SHOW_SHIPPING_WEIGHT_CHECKOUT_DESC'              => 'Wenn diese Option aktiviert ist, wird das Versandgewicht im Bestellvorgang bei allen Versandmodulen angezeigt',
];
